	title "Experimental 170 shift, 100 baud FSK demodulator (c) KC7WW"
	page    132,60
;****************************************************************************
;				RTTY.ASM 
; 		Experimental 170 shift, 100 baud FSK demodulator
;
;                       (c) Johan Forrer, KC7WW
;                       26553 Priceview Drive
;                         Monroe, OR 97456
;
; 			    March 1995
;****************************************************************************
;
; 			 Demodulator Block Diagram
;
;
;Fs=9600 SPS	         Decimator
;   |        /-------\	 /------\
;   \------> |  BPF  | ->| 1/2	|-----+-------------\
;            \-------/	 \------/     |	Fs=4800 SPS |
;				      |		    |
;				      v 	    v
;                                 /-------\	 /-------\
;                                 | M BPF |	 | S BPF |
;                                 \-------/      \-------/
;                                     |		     |
;				     ABS	    ABS
;				       \----<->----/
;					     |
;					     v
;					 /--------\
;				         |   LPF  |
;				         \--------/
;					     |
;					     v
;					 /--------\
;                   Automatic Threshold  | THRESH |------------>DTR
;                        Corrector       \--------/
;
;
; ----------------------- Principle of Operation ----------------------------
;
; This demodulator is based on "passband filtering" principles. The appropiate
; filter order for the discriminator section needs some explanation.
; For a matched filter, i.e., a filter that will allow the detection of a
; signal at optimal S/N, the envelope will be the sin(x)/x function. This
; envelope will have a maximum at the center of the symbol, and the null-to-
; null distance is 2T in the time domain or 1/(2T) in the frequency domain.
; For 100 baud, T=10ms, thus the null-to-null frequency domain bandwidth is
; 50 Hz. A narrower filter will not be able to capture all the signal energy
; while a wider one will capture more noise than it should.
; When using FIR filter design programs, one has to specify the stop band
; frequencies as well as the cut-off frequencies. In addition, one has to
; choose a filter order. Too low a filter order will probably mean that the
; filter design will not quite "make it" through the choosen stop band points.
; One will also then notice that the stop band rejection is not very high, 
; i.e., 15 - 20dB instead of the usual 50 or 60dB. Just increasing the filter
; order also is not a good idea because then the group delay for the FIR
; filter becomes large, i.e., 
; Group Delay = (filter order)/2 * (1/sample rate).
; This is important for ARQ systems that needs rapid turnaround response time.
; The optimal filter order is T/(1/Fs), however, if this tends to be too
; long, then shortening this a bit has no serious effects - all that happens
; is that filter skirts get marginally "rounded" and the stop band rejection
; gets a little lower. Keep in mind that even 20dB of rejection is very
; usable. 60dB is terrific, but hardly noticeable performance wise.
;
; The use of the decimator input stage serves three purposes. The following
; roughly describes these gains:
;(a) It decreases quantisation noise, i.e. going from the 16-bit A/D
; to the full 24-bit dynamic range. The explanion of this is: quantisation
; noise is spread over the sampled bandwidth. Since the decimation process
; includes a reduction of bandwidth, so does it crunch the noise component
; as well (remember it goes down by the square of the bandwidth).
;(b) The decimation filter has an "averaging" property, i.e., it will
; interpolate between the original 16-bit quantizing steps and in the
; process "create" near 24-bit quantizing steps.
;(c) Signal quality increases by addition and signal averaging - noise
; due its random behavior, tends to cancel. Nett effect is an increase
; in S/N.
;(d) To be able to create filters of any useful value at sample rate
; much higher than the passbands that it is intended, require high filter
; orders. The same is true for DSP than RF - building a 5 kHz wide filter
; at 1 MHz is much easier than doing it at 100 MHz. The trick of decimation
; is that it buys back efficiency at lower filter order. Just the fact that
; we are using a decimator front end allows us to use lower filter order in 
; the discriminator filters and at that - excellent performance. 
;******************************************************************************

	NOLIST
	include 'ttycod.asm'
	LIST

;******************************************************************************
TONE_OUTPUT     EQU     HEADPHONE_EN+LINEOUT_EN+(4*LEFT_ATTN)+(4*RIGHT_ATTN)   
TONE_INPUT      EQU     MIC_IN_SELECT+(15*MONITOR_ATTN)

ntaps   equ     32              ;number of taps in input bandpass filter
ftaps	equ	48		;number of taps in channel filters
dtaps	equ	48		;number of taps in data LPF
;******************************************************************************
;************ MAIN PROGRAM ****************************************************

	org     p:
main
;
; Initialize SC0 as input, SC1 as output
; These are connected to the optional terminal port    
;
    	bclr    #0,x:PCC                 ; SC0 - GPIO (PC0)
    	bclr    #0,x:PCC                 ; SC1 - GPIO (PC1)
    	bclr    #0,x:PCDDR               ; SC0 (PC0) - input
    	bset    #1,x:PCDDR               ; SC1 (PC1) - output

	movep   #$fb00,x:CRB            ; Enable the SSI interrupts.
	movep	#$301b,x:IPR		; IRQA/IRQB/SSI are level 3 interrupts.
					; and are LEVEL sensitive
	bset	#1,x:PCD		; Set output bit
;---------------------------------------------------------------------------
; Initialize pointer registers, r0, r1, r2, r3
; register r5 is used as temporary
;---------------------------------------------------------------------------
	move	#data_in,r0	; R0 points to input buffer pointer
        move    #ntaps-1,m0     ; mod(ntaps)

	move	#chan_in,r1	; R1 points to Channel input buffer pointer
        move    #ftaps-1,m1     ; mod(ftaps)

	move	#data_out,r2	; R2 points to data decimator pointer
        move    #dtaps-1,m2     ; mod(odtaps)

;
; Program headphone,lineout enabled, speaker off, attn=0
; The codec ISR will write these values on each CODEC cycle.
; We may wish to update the setting on the fly, if we wish, as they are
; in on-chip ram anyways.
;
	move    #TONE_OUTPUT,y0         ; headphones, line out, 
					; mute spkr, no attn.
	move    y0,x:<TX_BUFF_BASE+2
	move    #TONE_INPUT,y0          ; no input gain, monitor mute
	move    y0,x:<TX_BUFF_BASE+3

;
; Move coefficients from P data to Y data
;
	move	#IBPF,r4
	move	#pIBPF,r5
        .loop	#ntaps
        move    p:(r5)+,x0
	move	x0,y:(r4)+
	.endl

	move	#CH1,r4
	move	#pCH1,r5
        .loop	#ftaps
        move    p:(r5)+,x0
	move	x0,y:(r4)+
	.endl

	move	#CH2,r4
	move	#pCH2,r5
        .loop	#ftaps
        move    p:(r5)+,x0
	move	x0,y:(r4)+
	.endl

	move	#DLPF,r4
	move	#pDLPF,r5
        .loop	#dtaps
        move    p:(r5)+,x0
	move	x0,y:(r4)+
	.endl

;--------------- Main Loop -------------------------------------------------
loop_1 
	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.

	move    x:<RX_BUFF_BASE,a       ; Load the left channel input.
	move	a,x:LEFT_sig		; data appears left justified
	move	a,x:(r0)+		; save in circular buffer

;-------TEST-------------------
;	move    a,x:<TX_BUFF_BASE        ; Put value in left channel tx.
;	move    a,x:<TX_BUFF_BASE+1      ; Put value in right channel tx.  
;-------TEST-------------------

	move    x:<RX_BUFF_BASE+1,b     ; Load the right channel input.
	move	b,x:RIGHT_sig

;----------------------------------------------------------------------------
; Output signal for cross-pattern tuning
;----------------------------------------------------------------------------
	move	x:mark_tuning,a
	rep	#4			; scale for easier tuning
	asl	a
	move    a,x:<TX_BUFF_BASE       ; Put value in left channel tx.

	move	x:space_tuning,a
	rep	#4			; scale for easier tuning
	asl	a
	move    a,x:<TX_BUFF_BASE+1     ; Put value in right channel tx.  

;---------------------------------------------------------------------------
; Perform input bandpass filtering
; Sample rate = 9600 SPS
; On completion, pointers is same as in beginning, accum a contains result
;---------------------------------------------------------------------------

        move    #IBPF,r4      	; R4 point to filter coefficients
        move    #>-1,m4     	; linear addressing
	nop

        clr     a    x:(r0)+,x0  y:(r4)+,y0     ; priming registers
        .loop	#ntaps-1			; allow interrupts
	mac     x0,y0,a  x:(r0)+,x0  y:(r4)+,y0
	.endl
        macr    x0,y0,a				; final rounding

;-------TEST-------------------
;	move    a,x:<TX_BUFF_BASE        ; Put value in left channel tx.
;	move    a,x:<TX_BUFF_BASE+1      ; Put value in right channel tx.  
;-------TEST-------------------

;
; Use only every other sample, i.e., even numbered samples
;
	bchg	#0,X:Istate		; test lsb and flip it	
	jcs     <loop_1                 ; Loop back (short jump)

					; save in discrim. inp. bufr.
	move	a,x:(r1)+		; with saturation.

;---------------------------------------------------------------------------
; Perform discriminator channel filtering
; Sample rate = 4800 SPS
; On completion, pointers is same as in beginning, accum a contains result
;---------------------------------------------------------------------------
        move    #CH1,r4      	; R4 point to filter coefficients
        move    #>-1,m4     	; linear addressing
	move	r1,r5		; save r1
	
        clr     a    x:(r1)+,x0  y:(r4)+,y0     ; priming registers
        .loop	#ftaps-1			; allow interrupts using DO
	mac     x0,y0,a  x:(r1)+,x0  y:(r4)+,y0
	.endl
        macr    x0,y0,a				; final rounding
	move	a,x:mark_tuning			; save for tuning purposes
						; this is a saturated txfr

;-------TEST-------------------
;	move    a,x:<TX_BUFF_BASE        ; Put value in left channel tx.
;	move    a,x:<TX_BUFF_BASE+1      ; Put value in right channel tx.  
;-------TEST-------------------

	abs	a				; full wave rectification
;---------------------------------------------------------------------------

;-------TEST-------------------
;	move    a,x:<TX_BUFF_BASE        ; Put value in left channel tx.
;	move    a,x:<TX_BUFF_BASE+1      ; Put value in right channel tx.  
;-------TEST-------------------

	move	a,x:mark_sig

	move	r5,r1		; Restore  r1
        move    #CH2,r4      	; R4 point to filter coefficients
        move    #>-1,m4     	; linear addressing
	nop

        clr     a    x:(r1)+,x0  y:(r4)+,y0     ; priming registers
        .loop	#ftaps-1			; allow interrupts using DO
	mac     x0,y0,a  x:(r1)+,x0  y:(r4)+,y0
	.endl
        macr    x0,y0,a				; final rounding
	move	a,x:space_tuning		; save for tuning purposes
						; this is saturated txfr
	move	r5,r1		; Restore  r1

;-------TEST-------------------
;	move    a,x:<TX_BUFF_BASE        ; Put value in left channel tx.
;	move    a,x:<TX_BUFF_BASE+1      ; Put value in right channel tx.  
;-------TEST-------------------

	abs	a				; full wave rectification

;---------------------------------------------------------------------------
; Signal combiner  ABS(mark) - ABS(space)
;---------------------------------------------------------------------------
	move	a,x:space_sig
	move	x:mark_sig,b			; save a in b

	sub	b,a
	move	a,x:(r2)+			; save in LP delay line

;-------TEST-------------------
;;	move    a,x:<TX_BUFF_BASE        ; Put value in left channel tx.
;;	move    a,x:<TX_BUFF_BASE+1      ; Put value in right channel tx.  
;-------TEST-------------------

;---------------------------------------------------------------------------
; Perform output data LP filtering
; Sample rate = 4800 SPS
;---------------------------------------------------------------------------

        move    #DLPF,r4      	; R4 point to filter coefficients
        move    #>-1,m4     	; linear addressing
	nop

        clr     a    x:(r2)+,x0  y:(r4)+,y0     ; priming registers
        .loop	#dtaps-1			; allow interrupts
	mac     x0,y0,a  x:(r2)+,x0  y:(r4)+,y0
	.endl
        macr    x0,y0,a				; final rounding

;
; Slicer  output = 0 when a<0, else output = 1
;
thresh
	jmi	is_space 		; Slicer
	bclr	#1,x:PCD		; Clear output bit
	jmp     loop_1                  ; Loop back.
is_space
	bset	#1,x:PCD		; Set output bit
	jmp     loop_1                  ; Loop back.

;*****************************************************************************
; Data definitions
;-----------------------------------------------------------------------------
       org     x:      

data_in		dsm	ntaps	; storage for input data  (circular buffer)
chan_in		dsm	ftaps	; storage for channel filters (circ buffer)
data_out	dsm	dtaps	; storage for final LP filter (circ buffer)

LEFT_sig        ds      1       ; storage for Left Signal
RIGHT_sig       ds      1       ; storage for Left Signal
Istate		ds	1	; input decimator state	 (0/1)
data_bit	ds	1	; recovered data bit
mark_sig 	ds	1
space_sig	ds	1
mark_tuning 	ds	1
space_tuning	ds	1
outp		ds 1

;-----------------------------------------------------------------------------
; Coefficient staorage in RAM
;-----------------------------------------------------------------------------
	org	y:
IBPF	ds	ntaps
CH1	ds	chan_in
CH2	ds	chan_in
DLPF	ds	dtaps

;-----------------------------------------------------------------------------
	include 'rcoeffs.asm'	; various filter coefficients in P:RAM
;----------------------------------------------------------------------------
    end
